package org.jcg.zheng;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;

import java.util.Arrays;

import org.junit.Test;

public class CopyStringArrayTest extends TestBase {

	private String[] sourceStringArray = { "Mary", "Zheng", "Test" };

	private void validate_StringArray(String[] clonedArray) {
		// the copied object is a different reference
		assertFalse(System.identityHashCode(sourceStringArray) - System.identityHashCode(clonedArray) == 0);

		// change the clonedArray element does not affect the source array
		clonedArray[0] = "Dummy";

		assertEquals("Dummy", clonedArray[0]);
		assertEquals("Mary", sourceStringArray[0]);

		sourceStringArray[1] = "ZhengUpdate";
		assertEquals("Zheng", clonedArray[1]);
	}

	@Test
	public void via_Arrays_copyOf() {
		// since Java 1.6
		String[] copyofArr = Arrays.copyOf(sourceStringArray, sourceStringArray.length - 1);

		assertEquals(sourceStringArray.length - 1, copyofArr.length);
		assertEquals(sourceStringArray[0], copyofArr[0]);
		assertEquals(sourceStringArray[1], copyofArr[1]);

		validate_StringArray(copyofArr);
	}

	@Test
	public void via_Arrays_copyOfRange() {
		// since Java 1.6
		String[] copyofArr = Arrays.copyOfRange(sourceStringArray, copyStartAtZeroIndex, sourceStringArray.length - 1);

		assertEquals(sourceStringArray.length - 1, copyofArr.length);
		assertEquals(sourceStringArray[0], copyofArr[0]);
		assertEquals(sourceStringArray[1], copyofArr[1]);

		validate_StringArray(copyofArr);
	}

	@Test
	public void via_Arrays_stream_toArray() {
		String[] copyofArr = Arrays.stream(sourceStringArray).toArray(String[]::new);

		assertEquals(sourceStringArray.length, copyofArr.length);
		assertEquals(sourceStringArray[0], copyofArr[0]);
		assertEquals(sourceStringArray[1], copyofArr[1]);

		validate_StringArray(copyofArr);
	}

	@Test
	public void via_Object_clone() {
		// since 1.0
		String[] clonedArray = sourceStringArray.clone();

		assertEquals(sourceStringArray.length, clonedArray.length);
		assertEquals(sourceStringArray[0], clonedArray[0]);
		assertEquals(sourceStringArray[1], clonedArray[1]);

		validate_StringArray(clonedArray);
	}

	@Test
	public void via_System_arraycopy() {
		int length = 3;
		String[] destination = new String[length];

		// since 1.0
		System.arraycopy(sourceStringArray, copyStartAtZeroIndex, destination, copyStartAtZeroIndex, length);

		assertEquals(sourceStringArray.length, destination.length);
		assertEquals(sourceStringArray[0], destination[0]);
		assertEquals(sourceStringArray[1], destination[1]);

		validate_StringArray(destination);
	}
}