package org.jcg.zheng;

import org.junit.Test;

public class System_arraycopyTest extends TestBase {

	private DemoObject maryObject = new DemoObject('A', 1, "Mary");
	private DemoObject someObject = new DemoObject('B', 2, "Some data for test");

	private DemoObject[] sourceObjectArray = { maryObject, someObject, null };

	@Test(expected = ArrayIndexOutOfBoundsException.class)
	public void exception_when_copy_lenght_exceed_destination() {
		DemoObject[] destination = new DemoObject[1];
		// Since Java 1.0
		System.arraycopy(sourceObjectArray, 0, destination, 0, destination.length + 1);
	}

	@Test(expected = ArrayIndexOutOfBoundsException.class)
	public void exception_when_copy_length_exceed_source() {
		DemoObject[] destination = new DemoObject[5];
		// Since Java 1.0
		System.arraycopy(sourceObjectArray, 0, destination, 0, sourceObjectArray.length + 1);
	}

	@Test(expected = NullPointerException.class)
	public void exception_when_destination_is_null() {
		System.arraycopy(sourceObjectArray, 0, null, 0, sourceObjectArray.length);
	}

}