package org.jcg.zheng;

import java.time.Duration;
import java.time.Instant;

import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public class TestBase {

	@Rule
	public TestName name = new TestName();
	
	protected int copyStartAtZeroIndex = 0;
	
	Instant start;
	Instant finish;

	@After
	public void cleanup() {
		finish = Instant.now();
		Runtime after = Runtime.getRuntime();
		long totalAllocatedMemeryInBytes = after.totalMemory() - after.freeMemory();
		long totalTimeInNs = Duration.between(start, finish).toNanos();
		System.out.printf("\t%s completed in %d ns, used memory %d B\n", name.getMethodName(), totalTimeInNs,
				totalAllocatedMemeryInBytes);
	}

	@Before
	public void setup() {
		start = Instant.now();
	}

}