package com.javacodegeeks.examples.controller;

import javax.validation.Valid;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import com.javacodegeeks.examples.domain.User;
import com.javacodegeeks.examples.repository.UserRepository;

@Controller
@RequestMapping("users")
public class UserController {
	
    private final UserRepository userRepository;
    
    public UserController(UserRepository userRepository) {
        this.userRepository = userRepository;
    }
    
    @GetMapping
    public String displayForm(Model model) {
    	User user = new User();
    	model.addAttribute(user);
    	return "user-form";
    }

    @PostMapping
    public String addUser(
    		@ModelAttribute @Valid User user, BindingResult result, Model model) {
    	
    	if (result.hasErrors()) {
    		return "user-form";
    	}
    	
    	userRepository.save(user);
    	
    	Iterable<User> users = userRepository.findAll();
    	model.addAttribute("users", users);
    	return "user-list";
    }
}
