package LinkedList;

class Node {
    protected int data;
    protected CNode link;

    public Node() {
        link = null;
        data = 0;
    }

    public Node(int d, CNode n) {
        data = d;
        link = n;
    }

    public void setLink(CNode n) {
        link = n;
    }

    public void setData(int d) {
        data = d;
    }

    public CNode getLink() {
        return link;
    }

    public int getData() {
        return data;
    }
}

class LinkedList {
    protected CNode start;
    protected CNode end;
    public int size;

    public LinkedList() {
        start = null;
        end = null;
        size = 0;
    }

    public boolean isEmpty() {
        return start == null;
    }

    public int getSize() {
        return size;
    }

    public void insertAtStart(int val) {
        CNode nptr = new CNode(val, null);
        size++;
        if (start == null) {
            start = nptr;
            end = start;
        } else {
            nptr.setLink(start);
            start = nptr;
        }
    }

    public void insertAtEnd(int val) {
        CNode nptr = new CNode(val, null);
        size++;
        if (start == null) {
            start = nptr;
            end = start;
        } else {
            end.setLink(nptr);
            end = nptr;
        }
    }

    public void insertAtPos(int val, int pos) {
        CNode nptr = new CNode(val, null);
        CNode ptr = start;
        pos = pos - 1;
        for (int i = 1; i < size; i++) {
            if (i == pos) {
                CNode tmp = ptr.getLink();
                ptr.setLink(nptr);
                nptr.setLink(tmp);
                break;
            }
            ptr = ptr.getLink();
        }
        size++;
    }

    public void deleteAtPos(int pos) {
        if (pos == 1) // case covering the delete at beginning
        {
            start = start.getLink();
            size--;
            return;
        }
        if (pos == size) // case covering delete at end
        {
            CNode s = start;
            CNode t = start;
            while (s != end) {
                t = s;
                s = s.getLink();
            }
            end = t;
            end.setLink(null);
            size--;
            return;
        }
        CNode ptr = start;
        pos = pos - 1;
        for (int i = 1; i < size - 1; i++) {
            if (i == pos) {
                CNode tmp = ptr.getLink();
                tmp = tmp.getLink();
                ptr.setLink(tmp);
                break;
            }
            ptr = ptr.getLink();
        }
        size--;
    }

    public void display() {
        System.out.print("\n Linked List = ");
        if (size == 0) {
            System.out.print("empty\n");
            return;
        }
        if (start.getLink() == null) {
            System.out.println(start.getData());
            return;
        }
        CNode ptr = start;
        System.out.print(start.getData() + "->");
        ptr = start.getLink();
        while (ptr.getLink() != null) {
            System.out.print(ptr.getData() + "->");
            ptr = ptr.getLink();
        }
        System.out.print(ptr.getData() + "\n");
    }

    public static void main(String[] args) {
        LinkedList list = new LinkedList();
        System.out.println("Linked List Operation");
        int[] arr = {12, 9, 100};
        System.out.println("Starting Insert Operation on Linked List\n");
        System.out.println("Inserting arr elements in Linked List\n");
        list.insertAtStart(arr[0]);
        list.insertAtEnd(arr[2]);
        System.out.println("Linked List after the Insert Operation");
        list.display();
        System.out.println("Deleting elements in Binary Search Tree\n");
        for (int i = 0; i < arr.length; i++) {
            list.deleteAtPos(i);
        }
        System.out.println("Linked List after the Delete Operation");
        list.display();
    }
}
