package jcg.zheng.demo.array;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import org.junit.Test;

public class TwoDIntArrayTest {

	private static final int COLUMN_COUNT = 4;
	private static final int ROW_COUNT = 2;

	@Test
	public void declare_array() {
		int[][] anArray;
		System.out.println("done");
	}

	@Test
	public void declare_and_create_array() {
		int[][] anArray = new int[ROW_COUNT][];
		for (int i = 0; i < ROW_COUNT; i++) {
			assertNull(anArray[i]);
		}
	}

	@Test
	public void declare_and_create_array_with_column() {
		int[][] anArray = new int[ROW_COUNT][COLUMN_COUNT];

		for (int i = 0; i < ROW_COUNT; i++) {
			assertNotNull(anArray[i]);
			for (int j = 0; j < COLUMN_COUNT; j++) {
				assertEquals(0, anArray[i][j]);
			}
		}
	}

	@Test
	public void declare_create_and_initialize_array() {
		int[][] tableInt = new int[][] { { 1, 2, 3 }, { 6, 7, 8 }, { 5, 6, 7 } };

		print2DIntArray(tableInt);
	}

	@Test
	public void declare_create_assign_array() {
		int[][] tableInt = new int[ROW_COUNT][];

		for (int i = 0; i < ROW_COUNT; i++) {
			int[] row = new int[COLUMN_COUNT];
			tableInt[i] = row;
			for (int j = 0; j < COLUMN_COUNT; j++) {
				assertEquals(0, tableInt[i][j]);
			}
		}

	}

	private void print2DIntArray(int[][] tableInt) {
		for (int i = 0; i < tableInt.length; i++) {
			for (int j = 0; j < tableInt[i].length; j++) {
				System.out.printf("tableInt[%d][%d] = %d\n", i, j, tableInt[i][j]);
			}
			System.out.println();
		}
	}

	@Test(expected = ArrayIndexOutOfBoundsException.class)
	public void array_has_boundary() {
		int[] test = new int[ROW_COUNT];
		test[test.length] = 4;
	}

}
