package jcg.zheng.demo.array;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import jcg.zheng.demo.data.Card;

public class TwoDObjectArrayTest {

	private static final int COLUMN_COUNT = 4;
	private static final int ROW_COUNT = 2;
	
	@Test
	public void declare_and_create_2D_array_default_null() {
		Card[][] array_2d = new Card[ROW_COUNT][COLUMN_COUNT];

		for (int i = 0; i < ROW_COUNT; i++) {
			for (int j = 0; j < COLUMN_COUNT; j++) {
				assertEquals(null, array_2d[i][j]);
			}
		}
	}

	@Test
	public void declare_create_initialize_String_2d_array() {
		String[][] array_2d = new String[][] { { "apple", "orange" }, { "kiwi", "strawberry" },
				{ "cranberry", "grape" } };

		print2DArray(array_2d);
	}

	private void print2DArray(Object[][] array_2d) {
		for (int i = 0; i < array_2d.length; i++) {
			for (int j = 0; j < array_2d[i].length; j++) {
				System.out.printf("[%d][%d]=%s ", i, j, array_2d[i][j]);
			}
			System.out.println();
		}
	}

	@Test
	public void deal_poker_card_game() {
		// 4 players play one game of poker
		int PLAYER_COUNT = 4;
		int HAND_CARD_COUNT = 5;

		Card[][] cards = new Card[HAND_CARD_COUNT][PLAYER_COUNT];
		// draw first card for 4 players
		cards[0][0] = new Card("Spade", "1");
		cards[0][1] = new Card("Heart", "J");
		cards[0][2] = new Card("Diamond", "3");
		cards[0][3] = new Card("Club", "K");

		// draw second card for 4 players
		cards[1][0] = new Card("Heart", "1");
		cards[1][1] = new Card("Spade", "10");
		cards[1][2] = new Card("Club", "5");
		cards[1][3] = new Card("Diamond", "8");

		// draw third card for players
		cards[2][0] = new Card("Spade", "11");
		cards[2][1] = new Card("Heart", "A");
		cards[2][2] = new Card("Diamond", "8");
		cards[2][3] = new Card("Club", "K");

		// draw fourth card for players
		cards[3][0] = new Card("Heart", "9");
		cards[3][1] = new Card("Spade", "2");
		cards[3][2] = new Card("Club", "Q");
		cards[3][3] = new Card("Diamond", "7");

		// draw fifth card for players
		cards[4][0] = new Card("Heart", "5");
		cards[4][1] = new Card("Spade", "K");
		cards[4][2] = new Card("Club", "10");
		cards[4][3] = new Card("Diamond", "4");

		print2DArray(cards);

		// print out each player's hand
		for (int playerIdx = 0; playerIdx < PLAYER_COUNT; playerIdx++) {
			System.out.printf("\nPlayer " + (playerIdx + 1) + " hand :");

			for (int cardIndex = 0; cardIndex < HAND_CARD_COUNT; cardIndex++) {
				System.out.print(cards[cardIndex][playerIdx] + " ");
			}
		}

	}
}