package com.jcg.springboot.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import com.jcg.springboot.bean.EverydayBean;
import com.jcg.springboot.bean.SundayBean;
import com.jcg.springboot.condition.EverydayCondition;
import com.jcg.springboot.condition.IsTodayTheBestDayOfWeekCondition;

@Configuration
public class AppConfig {

	private static final Logger LOGGER = LoggerFactory.getLogger(AppConfig.class);

	@Bean
	@Conditional(value= IsTodayTheBestDayOfWeekCondition.class)
	public SundayBean createSundayBean() {
		LOGGER.info("Sunday bean is created successful.");
		return new SundayBean();
	}

	@Bean
	@Conditional(value= EverydayCondition.class)
	public EverydayBean createEverydayBean() {
		LOGGER.info("Everyday bean is created successful.");
		return new EverydayBean();
	}
}
