package jcg.zheng.demo;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

import jcg.zheng.demo.data.CollectionFields;
import jcg.zheng.demo.data.EnumExample;
import jcg.zheng.demo.data.ObjectFields;
import jcg.zheng.demo.data.PrimitiveFields;
import jcg.zheng.demo.modifier.AccessModifiers;
import jcg.zheng.demo.modifier.ChildExample;
import jcg.zheng.demo.modifier.InstanceModifiers;
import jcg.zheng.demo.modifier.RuntimeModifiers;

public class FieldReflectionDemo {

	public static void main(String[] args) {	 
		displayClassFields(EnumExample.GOLD);
		displayClassFields(new PrimitiveFields());
		displayClassFields(new ObjectFields());
		displayClassFields(new CollectionFields<Integer>());
		displayClassFields(new AccessModifiers(3));
		displayClassFields(new ChildExample(3, "Test"));
		displayClassFields(new InstanceModifiers());
		displayClassFields(new RuntimeModifiers());
	}

	private static void displayClassFields(Object obj) {
		try {
			Field[] allFields = obj.getClass().getDeclaredFields();
			System.out.print("\nClass " + obj.getClass().getName() + " has fields: ");

			for (Field f : allFields) {
				boolean updated = false;
				f.setAccessible(true);
				System.out.printf("\n\t %s %s = %s ", Modifier.toString(f.getModifiers()), f.getName(), f.get(obj));

				if (InstanceModifiers.INT_FIELD.equalsIgnoreCase(f.getName())) {
					f.set(obj, 47);
					updated = true;
				} else if (InstanceModifiers.PACKAGE_FIELD.equalsIgnoreCase(f.getName())) {
					f.set(obj, Integer.valueOf(2));
					updated = true;
				} else if (InstanceModifiers.STRING_FIELD.equalsIgnoreCase(f.getName())) {
					f.set(obj, "Java code geek");
					updated = true;
				} else if (InstanceModifiers.LONG_FIELD.equalsIgnoreCase(f.getName())) {
					f.set(obj, Long.valueOf(1000));
					updated = true;
				}

				if (updated) {
					System.out.printf("\n\t *Updated* %s %s = %s ", Modifier.toString(f.getModifiers()), f.getName(),
							f.get(obj));
				}

			}

		} catch (SecurityException | IllegalArgumentException | IllegalAccessException e) {
			e.printStackTrace();
		}
	}

}
