package jcg.zheng.demo.modifier;

import java.io.Serializable;

public class RuntimeModifiers implements Serializable {
	private static final long serialVersionUID = 4192336936121085734L;
	
	private String name;
	private transient String password;
	private static volatile RuntimeModifiers instance;

	public static RuntimeModifiers getInstance() {
		if (instance == null) {
			synchronized (RuntimeModifiers.class) {
				if (instance == null) {
					instance = new RuntimeModifiers();
				}
			}
		}

		return instance;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	@Override
	public String toString() {
		return "RuntimeModifierExample [name=" + name + ", password=" + password + "]";
	}

}
