package jcg.zheng.demo.data;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

public class CollectionFieldsTest {

	private CollectionFields<Integer> testClass = new CollectionFields<>();

	@Test
	public void test_field_intArray() {
		int[] arrayField = new int[2];
		arrayField[0] = 1;
		arrayField[1] = 4;
		testClass.setArrayField(arrayField);
		
		assertEquals(1, testClass.getArrayField()[0]);
		assertEquals(4, testClass.getArrayField()[1]);
	}

	@Test
	public void test_field_list() {
		assertTrue(testClass.getListField_initialized().isEmpty());

		testClass.addListField_initialized(5);
		assertFalse(testClass.getListField_initialized().isEmpty());
		assertEquals(5, testClass.getListField_initialized().get(0).intValue());
	}

}
