package jcg.zheng.demo.data;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

import jcg.zheng.demo.data.EnumExample;
import jcg.zheng.demo.data.ObjectFields;
import jcg.zheng.demo.data.PrimitiveFields;

public class ObjectFieldsTest {

	private ObjectFields testClass = new ObjectFields();

	@Test
	public void test_field_enum() {
		assertNull(testClass.getEnumField());

		testClass.setEnumField(EnumExample.GOLD);
		assertEquals(EnumExample.GOLD, testClass.getEnumField());
	}

	@Test
	public void test_field_object() {
		assertNull(testClass.getObjectField());

		testClass.setObjectField(new PrimitiveFields());
		assertEquals(0, testClass.getObjectField().getIntField());

	}

	@Test
	public void test_field_string() {
		assertNull(testClass.getStringField());

		testClass.setStringField("Mary");
		assertEquals("Mary", testClass.getStringField());
	}

}
