package jcg.zheng.demo.data;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import jcg.zheng.demo.data.PrimitiveFields;

/**
 * Test the default value for the field with primitive type and the getter and setter
 * @author Mary Zheng
 *
 */
public class PrimitiveFieldsTest {

	private PrimitiveFields testClass = new PrimitiveFields();

	@Test
	public void test_field_boolean() {
		assertFalse(testClass.isBooleanField());
		
		testClass.setBooleanField(true);
		assertTrue(testClass.isBooleanField());
	}

	@Test
	public void test_field_char() {
		assertEquals('\u0000', testClass.getCharField());
		
		testClass.setCharField('M');
		assertEquals('M', testClass.getCharField());
	}

	@Test
	public void test_field_double() {
		assertEquals(0.00, testClass.getDoubleField(), 2);

		testClass.setDoubleField(34.8);
		assertEquals(34.8, testClass.getDoubleField(), 2);
	}

	@Test
	public void test_field_int() {
		assertEquals(0, testClass.getIntField());
		
		testClass.setIntField(1);
		assertEquals(1, testClass.getIntField());
	}

	@Test
	public void test_field_long() {
		assertEquals(0, testClass.getLongField());
		
		testClass.setLongField(100l);
		assertEquals(100l, testClass.getLongField());
	}

	@Test
	public void test_field_short() {
		assertEquals(0, testClass.getShortField());
		
		testClass.setShortField((short) 1);
		assertEquals(1, testClass.getShortField());
	}
	
	@Test
	public void test_field_byte() {
		assertEquals(0, testClass.getByteField());
		
		testClass.setByteField((byte) 1);
		assertEquals(1, testClass.getByteField());
	}
	
	@Test
	public void test_field_float() {
		assertEquals(0.00, testClass.getFloatField(), 2);

		testClass.setFloatField(34.8f);
		assertEquals(34.8, testClass.getFloatField(), 2);
	}

}
