package jcg.zheng.demo.modifier;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

public class AccessModifiersTest {

	private AccessModifiers testClass = new AccessModifiers(3);

	@Test
	public void child_class_can_access_default_protected_public() {
		System.out.println(testClass.toString());
		assertNull(testClass.packageField);
		assertNull(testClass.longField);
		assertNull(testClass.stringField);

		testClass.packageField = Integer.valueOf(5);
		testClass.stringField = "Mary";
		testClass.longField = Long.valueOf(12);
		
		System.out.println(testClass.toString());
		assertEquals(5, testClass.packageField.intValue());
		assertEquals("Mary", testClass.stringField);
		assertEquals(12, testClass.longField.intValue());
	}
}
