package jcg.zheng.demo.modifier;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

import jcg.zheng.demo.modifier.ChildExample;

public class ChildExampleTest {
	private ChildExample testClass = new ChildExample(3, "Test");

	@Test
	public void child_class_can_access_default_protected_public() {
		System.out.println(testClass.toString());
		assertNull(testClass.packageField);
		assertNull(testClass.stringField);
		assertNull(testClass.longField);
		
		testClass.packageField = Integer.valueOf(1);
		testClass.stringField = "Zheng";
		testClass.longField = Long.valueOf(2);
	 
		System.out.println(testClass.toString());
		assertEquals(1, testClass.packageField.intValue());
		assertEquals("Zheng", testClass.stringField);
		assertEquals(2, testClass.longField.intValue());
	}

}
