package jcg.zheng.demo.modifier;

import static org.junit.Assert.assertNull;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.junit.Test;

public class RuntimeModifiersTest {
	private static final String SERIALIZED_FILE_NAME = "transient.ser";
	private RuntimeModifiers testClass = RuntimeModifiers.getInstance();

	@Test
	public void transient_not_serialized() {

		serializedObj();

		RuntimeModifiers deObj = deserializedObj();
		assertNull(deObj.getPassword());

		System.out.println(deObj.toString());
	}

	private void serializedObj() {
		try {
			ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(SERIALIZED_FILE_NAME));

			testClass.setName("Mary");
			testClass.setPassword("shouldNotSerialized");

			oos.writeObject(testClass);
			oos.close();
			System.out.println(testClass.toString());

		} catch (IOException e) {

			e.printStackTrace();
		}
	}

	private RuntimeModifiers deserializedObj() {
		RuntimeModifiers ret = null;
		try {
			ObjectInputStream ooi = new ObjectInputStream(new FileInputStream(SERIALIZED_FILE_NAME));

			ret = (RuntimeModifiers) ooi.readObject();

			ooi.close();

		} catch (IOException | ClassNotFoundException e) {
			e.printStackTrace();
		}

		return ret;

	}

}
