package jcg.zheng.demo.api.impl;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class CompositionClassTest {

	private CompositionClass testClass = new CompositionClass();

	@Test
	public void composition_not_shadowingData() {
		BaseClass bCls = new BaseClass();
		bCls.setSomeData("Test");
		bCls.shadowingData = "BaseClass.shadowingData is not shadowing at composition";
		testClass.shadowingData ="OK";
		
		testClass.setbCls(bCls );
		assertEquals("Test", testClass.getbCls().getSomeData());
		assertEquals("BaseClass.shadowingData is not shadowing at composition", testClass.getbCls().shadowingData);
	}

}
