package jcg.zheng.demo.api.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

public class Parent_YTest {

	private Parent_Y testClass = new Parent_Y("Mary");

	@Test
	public void foo1() {
		// if BaseClass.foo1 not meet the sub class's need. then you must be change at
		// the super class which other subclass may not agree with you!
		assertEquals("BaseClass.foo1 Zheng", testClass.foo1("Zheng"));
	}

	@Test
	public void foo2() {
		assertEquals("Mary foo2: Zheng", testClass.foo2("Zheng"));
	}

	@Test
	public void foo3() {
		assertEquals("Mary foo3: Zheng", testClass.foo3("Zheng"));
	}

	@Test
	public void inherited_methods() {
		testClass.setSomeData("Common Data");
		assertEquals("Common Data", testClass.getSomeData());
	}

	@Test
	public void shadowingData_is_bad_as_it_hide_fields() {
		testClass.shadowingData = "Test";
		assertEquals("Test", testClass.shadowingData);
		assertNull(((BaseClass) testClass).shadowingData);
	}

}
