package com.jcg.service;

import com.jcg.entity.Employee;
import com.jcg.util.HibernateUtil;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class HibernateApp {
    public static void main(String[] args) {
        SessionFactory sessionFactory = HibernateUtil.getSessionFactory();
        if(sessionFactory != null) {
           createEmployees(sessionFactory);
           listEmployees(sessionFactory);
        }
    }

    public static void listEmployees(SessionFactory sessionFactory) {
        System.out.println("############# Employees list ##################");
        Session session = sessionFactory.openSession();
        List<Employee> employees = session.createQuery("FROM Employee").list();
        for (Employee employee : employees) {
            System.out.println(String.format("Name : %s %s", employee.getFirstName(), employee.getLastName()));
            System.out.println(String.format("Date of Birth: %s", employee.getDateOfBirth()));
            System.out.println("----------------------------------------------------------------");
        }
    }

    public static void createEmployees(SessionFactory sessionFactory) {
        Calendar myCalendar = new GregorianCalendar(1986, 2, 11);
        Employee e1 = new Employee("Santosh", "BS", myCalendar.getTime());

        myCalendar = new GregorianCalendar(1980, 2, 11);
        Employee e2 = new Employee("James", "J", myCalendar.getTime());
        System.out.println("########### Saving employee details to database #############");
        Session session = sessionFactory.openSession();
        session.beginTransaction();
        session.save(e1);
        session.save(e2);
        session.getTransaction().commit();
    }
}
