package com.jcg.service;

import com.jcg.entity.Employee;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import static javax.xml.bind.DatatypeConverter.parseDate;

public class HibernateAppService {
    public static void main(String[] args) {
        SessionFactory sessionFactory = new Configuration().configure()
                .buildSessionFactory();
        try {
            if (sessionFactory != null) {
                createEmployees(sessionFactory);
                listEmployees(sessionFactory);
            }
        } finally {
            sessionFactory.close();
        }
    }

    public static void listEmployees(SessionFactory sessionFactory) {
        System.out.println("############# Employees list ##################");
        Session session = sessionFactory.openSession();
        List<Employee> employees = session.createQuery("FROM Employee").list();
        for (Employee employee : employees) {
            System.out.println(String.format("Name : %s %s", employee.getFirstName(), employee.getLastName()));
            System.out.println(String.format("Date of Birth: %s", employee.getDateOfBirth()));
            System.out.println("----------------------------------------------------------------");
        }
    }

    public static void createEmployees(SessionFactory sessionFactory) {
        Calendar myCalendar = new GregorianCalendar(1986, 2, 11);
        Employee e1 = new Employee("Santosh", "BS", myCalendar.getTime());

        myCalendar = new GregorianCalendar(1980, 2, 11);
        Employee e2 = new Employee("James", "J", myCalendar.getTime());
        System.out.println("########### Saving employee details to database #############");
        Session session = sessionFactory.openSession();
        session.beginTransaction();
        session.save(e1);
        session.save(e2);
        session.getTransaction().commit();
    }
}
