package org.example;

public class MatrixMultiplication {
    public static void main(String[] args) {
        System.out.println("Matrix Multiplication");

        int[][] firstMatrix = {{1, 1, 1}, {2, 2, 2}, {3, 3, 3}};
        int[][] secondMatrix = {{1, 1, 1}, {2, 2, 2}, {3, 3, 3}};

        System.out.println("First Matrix:\n");
        displayMatrix(firstMatrix);

        System.out.println("Second Matrix:\n");
        displayMatrix(secondMatrix);

        multiply(firstMatrix, secondMatrix);
    }

    private static void multiply(int[][] first, int[][] second) {
        int row = first.length;
        int column = first[0].length;
        int[][] product = new int[row][column];

        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 3; j++) {
                product[i][j] = 0;
                for (int k = 0; k < 3; k++) {
                    product[i][j] += first[i][k] * second[k][j];
                }
            }
        }
        System.out.println("\nMultiplication of Matrices:\n");
        displayMatrix(product);
    }

    private static void displayMatrix(int[][] matrix) {
        for (int r = 0; r < matrix.length; r++) {
            for (int c = 0; c < matrix[0].length; c++) {
                System.out.print(matrix[r][c] + "\t");
            }
            System.out.println();
        }
    }
}
