package jcg.zheng.demo.stream;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.junit.Test;

import jcg.zheng.demo.DemoPOJO;

public class StreamMapTest extends TestBase {

	@Test
	public void string_function() {
		Function<String, String> toUpper = String::toUpperCase;
		List<String> allUppercase = lowerCaseStrings.stream().map(toUpper).collect(Collectors.toList());
		validateUpperCaseTransform(allUppercase);
	}

	@Test
	public void string_lambda() {
		List<String> allUppercase = lowerCaseStrings.stream().map(n -> n.toUpperCase()).collect(Collectors.toList());
		validateUpperCaseTransform(allUppercase);
	}

	@Test
	public void string_method_reference() {
		List<String> allUppercase = lowerCaseStrings.stream().map(String::toUpperCase).collect(Collectors.toList());
		validateUpperCaseTransform(allUppercase);
	}

	@Test
	public void object_lambda() {
		List<String> names = testObjects.stream().map(obj -> obj.getName()).collect(Collectors.toList());
		validateTestObject(names);
	}

	@Test
	public void object_function() {
		Function<DemoPOJO, Integer> transform = DemoPOJO::nameWordCount;
		List<Integer> nameCounts = testObjects.stream().map(transform).collect(Collectors.toList());
		nameCounts.forEach(s -> System.out.println(s));
	}

	@Test
	public void object_methodReference() {
		List<String> names = testObjects.stream().map(DemoPOJO::getName).collect(Collectors.toList());
		validateTestObject(names);
	}

}
