package jcg.zheng.demo.stream;

import static org.junit.Assert.assertEquals;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import org.junit.Test;

public class StreamMap_IntermediateOperationTest extends TestBase {
	
	@Test
	public void filter_map() {
		Predicate<String> shortName = name -> name.length() < 4;
		List<String> shortNames = lowerCaseStrings.stream().filter(shortName).map(String::toUpperCase)
				.collect(Collectors.toList());
		assertEquals("END", shortNames.get(0));
	}

	@Test
	public void map_filter() {
		Predicate<String> shortName = name -> name.length() < 4;
		List<String> shortNames = lowerCaseStrings.stream().map(String::toUpperCase).filter(shortName)
				.collect(Collectors.toList());
		assertEquals("END", shortNames.get(0));
	}

	@Test
	public void map_map() {
		Function<String, String> prefix = n -> "PRE_" + n;
		lowerCaseStrings.stream().map(prefix).map(String::toUpperCase).forEach(e -> System.out.println(e));
	}
	
	@Test
	public void map_peek() {
		//peek is for debugging purpose to see the elements in the Stream
		lowerCaseStrings.stream().map(String::toUpperCase).peek(e -> System.out.println(e)).collect(Collectors.toList());
	}

}
