package jcg.zheng.demo.stream;

import static org.junit.Assert.assertEquals;

import java.util.List;
import java.util.stream.Collectors;

import org.junit.Test;

public class StreamMap_TerminalOperationTest extends TestBase {

	@Test
	public void map_collect() {
		List<String> allUppercase = lowerCaseStrings.stream().map(String::toUpperCase).collect(Collectors.toList());
		validateUpperCaseTransform(allUppercase);
	}

	@Test
	public void map_filter_count() {
		long maryCount = lowerCaseStrings.stream().map(String::toUpperCase).filter(e -> e.equalsIgnoreCase("MARY"))
				.count();
		assertEquals(1, maryCount);
	}

	@Test
	public void map_foreach() {
		lowerCaseStrings.stream().map(String::toUpperCase).forEach(s -> System.out.println(s));
	}

	@Test
	public void map_toArray() {
		Object[] upperArr = lowerCaseStrings.stream().map(String::toUpperCase).toArray();
		assertEquals("MARY", upperArr[0]);
		assertEquals("SOMETHING", upperArr[1]);
		assertEquals("END", upperArr[2]);
	}
}
