import java.util.TimerTask;
import java.util.Timer;
import java.util.Date;

public class TimerTest{
    public static void main(String args[]){
        TimerTask task = new MyTask();
        // usage of constructor public Timer(String name)
        Timer timer = new Timer("Timer#1");
        System.out.println("Schedule timer with 1 sec delay at :"+new Date());
        // usage of method schedule(TimerTask task, long delay)
        timer.schedule(task,1000L);
        // provide a time delay for the task to complete
        try{
            Thread.sleep(5000L);
        } catch(InterruptedException e){
            e.printStackTrace();
        }
        System.out.println("Canceling Timer#1");
        // usage of method cancel
        timer.cancel();
        System.out.println("Cancelled Timer#1");
        
        // create another timer to demonstrate usage of scheduleAtFixedRate method
        Timer timer2 = new Timer("Timer#2");
        TimerTask task2 = new MyTask();
        System.out.println("Schedule timer#2 after a delay of 1 sec and 3 second period");
        // usage of method scheduleAtFixedRate(TimerTask task, long delay, long period)
        timer2.scheduleAtFixedRate(task2,1000L,3000L);
        System.out.println("Schedule timer#2 job done");
        // provide a time delay for the task to complete
        try{
            Thread.sleep(10000L);
        } catch(InterruptedException e){
            e.printStackTrace();
        }
        
        System.out.println("Canceling Timer#2");
        // usage of method cancel
        timer2.cancel();
        System.out.println("Cancelled Timer#2");
        
    }
}