package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;

import java.util.Arrays;
import java.util.LinkedHashSet;

import org.junit.Test;

public class CompareToLinkedHashSetTest {

	private String[] listHasDuplicates = { "Shan", "Mary", "Mary", "Zheng", "Zheng" };
	private LinkedHashSet<String> setObj;

	@Test
	public void is_not_sorted_can_have_null() {
		assertEquals(5, listHasDuplicates.length);
		listHasDuplicates[listHasDuplicates.length - 1] = null;
		assertEquals(5, listHasDuplicates.length);

		setObj = new LinkedHashSet<>(Arrays.asList(listHasDuplicates));

		System.out.println(setObj);
		assertEquals(4, setObj.size());
	}

	@Test
	public void LinkedHasSet_keeps_insertion_order() {
		assertEquals(5, listHasDuplicates.length);
		setObj = new LinkedHashSet<>(Arrays.asList(listHasDuplicates));

		assertEquals(3, setObj.size());
		//always "Shan", "Mary", "Zheng" order
		System.out.println(setObj);

	}

}
