package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

import org.junit.Test;

public class CompareToTreeSetTest {

	private String[] listHasDuplicates = { "Shan", "Mary", "Mary", "Zheng", "Zheng" };
	private Set<String> treeSet = new TreeSet<>();

	@Test
	public void HashSet_is_not_sorted_can_have_null() {
		listHasDuplicates[listHasDuplicates.length - 1] = null;
		assertEquals(5, listHasDuplicates.length);
		Set<String> notOrderHashset = new HashSet<>(Arrays.asList(listHasDuplicates));

		System.out.println(notOrderHashset);
		assertEquals(4, notOrderHashset.size());
	}

	@Test(expected=ConcurrentModificationException.class)
	public void not_thread_safe_because_cannot_modify_while_iterate() {
		treeSet.add("Mary");
		treeSet.add("Zheng");
		treeSet.add("Tom");
	 
		Iterator<String> iterator = treeSet.iterator();
		while (iterator.hasNext()) {
			iterator.next();
			treeSet.add("Test");
		}
		 
	}

	@Test(expected = NullPointerException.class)
	public void TreeSet_can_not_have_null() {
		treeSet.add(null);
	}
	
	@Test
	public void TreeSet_is_sorted() {
		assertEquals(5, listHasDuplicates.length);
		TreeSet<String> orderedTreeSet = new TreeSet<>(Arrays.asList(listHasDuplicates));

		System.out.println(orderedTreeSet);
		assertEquals(3, orderedTreeSet.size());
		assertEquals("Mary", orderedTreeSet.first());
		assertEquals("Zheng", orderedTreeSet.last());
	}

}
