package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.junit.Test;

public class HashSetTest {

	private Set<String> testClass = new HashSet<>();

	@Test
	public void can_add_null() {
		assertTrue(testClass.isEmpty());
		testClass.add(null);
		assertFalse(testClass.isEmpty());
		
		boolean removed = testClass.remove(null);
		assertTrue(removed);
		assertTrue(testClass.isEmpty());
	}

	@Test
	public void can_read_while_iterate() {
		testClass.add("Mary");
		testClass.add("Zheng");

		Iterator<String> iterator = testClass.iterator();
		while (iterator.hasNext()) {
			String item = iterator.next();
			System.out.println(item);
			Iterator<String> iterator2 = testClass.iterator();
			while (iterator2.hasNext()) {
				System.out.println("\titerator2 " + iterator2.next());
			}
		}
		testClass.clear();
		assertTrue(testClass.isEmpty());
	}

	@Test
	public void no_duplicate() {
		assertTrue(testClass.isEmpty());
		
		boolean added = testClass.add(null);
		assertTrue(added);
		assertFalse(testClass.isEmpty());
	
		
		added = testClass.add("Mary");
		assertTrue(added);
		assertEquals(2, testClass.size());
		
		
		added = testClass.add(null);
		assertFalse(added);
		
		added = testClass.add("Mary");
		assertFalse(added);
		
	
		
		boolean removed = testClass.remove("Mary");
		assertTrue(removed);
		assertEquals(1, testClass.size());
		
		removed = testClass.remove("Mary");
		assertFalse(removed);
	}

	@Test(expected = java.util.ConcurrentModificationException.class)
	public void not_thread_safe_cannot_modify_while_iterate() {
		testClass.add("Mary");
		testClass.add("Zheng");

		Iterator<String> iterator = testClass.iterator();
		while (iterator.hasNext()) {
			String item = iterator.next();
			if ("Zheng".equalsIgnoreCase(item)) {
				testClass.remove(item);// will throw exception
			}
		}
	}
	

	@Test
	public void order_is_not_same_as_inserted() {
		for (int i = 0; i < 19; i++) {
			testClass.add(String.valueOf(i));
		}
		// [11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
		System.out.println(testClass.toString());
	}

	@Test
	public void use_iterator_remove() {
		testClass.add("Mary");
		testClass.add("Zheng");

		Iterator<String> iterator = testClass.iterator();
		while (iterator.hasNext()) {
			String item = iterator.next();
			if ("Zheng".equalsIgnoreCase(item)) {
				iterator.remove();
			}
		}

		assertEquals(1, testClass.size());
		assertTrue(testClass.contains("Mary"));
		assertFalse(testClass.contains("Zheng"));
	}
}
