package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.junit.Test;

public class HashSet_ConstructorTest {

	@Test
	public void via_collection_list() {
		HashSet<String> fromAnotherCollection = new HashSet<>(Arrays.asList("Mary", "Zheng"));
		assertFalse(fromAnotherCollection.isEmpty());
		assertTrue(fromAnotherCollection.contains("Mary"));
		assertTrue(fromAnotherCollection.contains("Zheng"));
	}

	@Test
	public void via_collection_set() {
		Set<String> fromCollectionUtils = Collections.singleton("Mary");
		assertFalse(fromCollectionUtils.isEmpty());
		assertTrue(fromCollectionUtils.contains("Mary"));
	}

	@Test
	public void via_default_constructor() {
		// Default initial capacity is 16
		// Default load factor is 0.75
		HashSet<String> createdByDefaultConstructor = new HashSet<>();

		assertTrue(createdByDefaultConstructor.isEmpty());
	}
	

	@Test
	public void via_initialCapacity_constructor() {
		// initial capacity is 0
		// Default load factor is 0.75
		HashSet<String> createdByDefaultConstructor = new HashSet<>(0);

		assertTrue(createdByDefaultConstructor.isEmpty());
	}

	@Test
	public void via_initialCapacity_loadfactor_constructor() {
		// initial capacity is 0
		// load factor is 1
		HashSet<String> createdByDefaultConstructor = new HashSet<>(0, 1);

		assertTrue(createdByDefaultConstructor.isEmpty());
	}

	@Test
	public void via_list() {
		List<String> listHasDuplicates = Arrays.asList("Mary", "Zheng", "Mary", "Zheng");
		assertEquals(4, listHasDuplicates.size());
		HashSet<String> fromList = new HashSet<>(listHasDuplicates);
		assertEquals(2, fromList.size());
	}

	@Test
	public void via_stream() {
		HashSet<String> fromStream = Stream.of("Mary", "Zheng").collect(Collectors.toCollection(HashSet::new));
		assertFalse(fromStream.isEmpty());
		assertTrue(fromStream.contains("Mary"));
		assertTrue(fromStream.contains("Zheng"));
	}

	@Test
	public void via_via_anonymous_collection() {
		@SuppressWarnings("serial")
		HashSet<String> fromAnonymousClass = new HashSet<>() {
			{
				add("Mary");
				add("Zheng");
			}
		};

		assertFalse(fromAnonymousClass.isEmpty());
		assertTrue(fromAnonymousClass.contains("Mary"));
		assertTrue(fromAnonymousClass.contains("Zheng"));
	}

}
