/**
 * @author bhagvan.kommadi
 *
 */
import java.util.TreeSet;
import java.util.Set;

class Employee implements Comparable<Employee> {
	int id;
	String name;

	Employee(int id, String name) {
		this.id = id;
		this.name = name;

	}

	public int compareTo(Employee emp) {
		if (id > emp.id) {
			return 1;
		} else if (id < emp.id) {
			return -1;
		} else {
			return 0;
		}
	}
}

public class TreeSetExample {
	public static void main(String[] args) {
		Set<Employee> employeeSet = new TreeSet<Employee>();

		Employee emp1 = new Employee(1, "John Smith");
		Employee emp2 = new Employee(2, "William Brady");
		Employee emp3 = new Employee(3, "George Smith");

		employeeSet.add(emp1);
		employeeSet.add(emp2);
		employeeSet.add(emp3);

		for (Employee emp : employeeSet) {
			System.out.println(emp.id + " " + emp.name);
		}
	}
}
