package com.javacodegeeks.examples.ws;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import javax.annotation.PostConstruct;
import javax.jws.WebService;

@WebService(endpointInterface = "com.javacodegeeks.examples.ws.RandomQuote")
public class RandomQuoteImpl implements RandomQuote {

	private List<String> quoteList;

	@PostConstruct
	private void createList() throws FileNotFoundException, IOException {
		
		quoteList = new ArrayList<String>();
		File file = getFileFromResources("quote.txt");
		try (FileReader reader = new FileReader(file); 
			 BufferedReader br = new BufferedReader(reader)) {

			String line;
			while ((line = br.readLine()) != null) {
				quoteList.add(line);
			}
		}
	}

	@Override
	public String getQuote() {
		Random random = new Random();
		int index = random.nextInt(quoteList.size());
		return (String) quoteList.get(index);
	}

	private File getFileFromResources(String fileName) {

		ClassLoader classLoader = getClass().getClassLoader();
		URL resource = classLoader.getResource(fileName);
		if (resource == null) {
			throw new IllegalArgumentException("file is not found!");
		} else {
			return new File(resource.getFile());
		}

	}
}
