package com.accion.reactive.configuration;

// As soon as this program run it loads the runtime classes into the Heap space.
public class Employee {

	// The main() found creates a Stack memory that will be used by the main() method thread.
	public static void main(String[] args) {
		// This local variable is created and stored in the stack memory of the main() method.
		int index = 1;

		// This object creation is created in the Heap space and the Stack memory contains a reference for it.
		Object myObject = new Object();

		// This object creation is created in the Heap space and the Stack memory contains a reference for it.
		Employee myEmployee = new Employee();

		// Now calling the "someMethod()", a block in the top of the Stack memory is created and is used by
		// the "someMethod()" method. Since Java is pass-by-value in nature, a new reference to Object is created 
		// in the "someMethod" stack block.
		myEmployee.someMethod(myObject);
	
	}	// At this point the "main()" terminates as it has done it job and the Stack space created for 
		// "main()" method is destroyed. Also the program ends and hence the JRE frees all the memory
		// and ends the program execution.

	private void someMethod(Object object) {
		// The string created goes to the "String Pool" that residers in the heap space and the reference of it
		// is created in the "someMethod()" stack space.
		String name = object.toString();
		System.out.println("Name= " + name);
	
	}	// At this point the "someMethod()" terminates and the memory block allocated for "someMethod()"
		// in the Stack space becomes free.
}
