/**
 * 
 */
package com.javacodegeeks.examples;

/**
 * This is Mexican-style implementation of Bake Pizza interface.
 * 
 * @author Shivakumar Ramannavar
 *
 */
public class MexicanPizza implements BakePizza, PrepareDrinks {

	/* (non-Javadoc)
	 * @see com.javacodegeeks.examples.
	 *       BakePizza#preparePizza(java.lang.String, java.lang.String[])
	 */
	@Override
	public void preparePizza(String pizzaType, String... toppings) {
		System.out.println("\tPreparing the " + pizzaType 
                + " pizza in a Mexican style ...");
		System.out.println("\tPutting it into the oven ...");
		System.out.println("\tThe pizza is baked!");
		System.out.println("\tTake your pizza!\n");
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.javacodegeeks.examples.PrepareDrinks#prepareDrink(java.lang.String)
	 */
	@Override
	public void prepareDrink(String drinkType) {
		System.out.println("\tPreparing the " + drinkType 
                + " drink in a Mexican style ...");
		System.out.println("\tPutting it into the cup ...");		
		System.out.println("\tTake your drink!\n");		
	}
}
