package jcg.ssowmya.demo.graphExample;

import java.util.Objects;

public class ServerVertex {
    private String label;
    private ServerConfig serverConfig;

    public ServerVertex(String label,ServerConfig serverConfig) {
        this.label = label;
        this.serverConfig = serverConfig;
    }
    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ServerConfig getServerConfig() {
        return serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    @Override
    public String toString() {
        return "Vertex{" +
                "label='" + label + '\'' +
                ", serverConfig=" + serverConfig +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServerVertex serverVertex = (ServerVertex) o;
        return getServerConfig().equals(serverVertex.getServerConfig());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getServerConfig());
    }
}
