package jcg.ssowmya.demo.graphExample;

import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

public class ServerGraphTest {

    @Test
    public void testGraphServerVertices() {
        ServerGraph serverGraph = new ServerGraph();
        assertNotNull(serverGraph.getAdjServerVertices());
        serverGraph.addServerVertex(new ServerVertex("WS1:Web Server", new ServerConfig("JCG Web Server 1","1.2.3.4","Web")));
        assertEquals(1,serverGraph.getAdjServerVertices().size());
        serverGraph.removeServerVertexByIpAddress("1.2.3.4");
        assertEquals(0,serverGraph.getAdjServerVertices().size());
    }

    @Test
    public void testGraphServerEdges() {
        ServerGraph serverGraph = new ServerGraph();
        ServerVertex wsVertex= new ServerVertex("WS1:Web Server",new ServerConfig("JCG Web Server 1","1.2.3.4","Web"));
        ServerVertex lb1Vertex = new ServerVertex("LB1:Load Balancer 1", new ServerConfig("JCG Load Balance Server 1","1.2.3.5","Load Balancer"));
        serverGraph.addServerVertex(wsVertex);
        serverGraph.addServerVertex(lb1Vertex);
        assertEquals(2,serverGraph.getAdjServerVertices().size());
        serverGraph.addEdge(new ServerEdge(wsVertex,lb1Vertex));
        assertEquals(1,serverGraph.getAdjServerVertices().get(wsVertex).size());
        assertEquals(1,serverGraph.getAdjServerVertices().get(lb1Vertex).size());
        serverGraph.removeEdge(new ServerEdge(wsVertex,lb1Vertex));
        assertEquals(0,serverGraph.getAdjServerVertices().get(wsVertex).size());
        assertEquals(0,serverGraph.getAdjServerVertices().get(lb1Vertex).size());
    }
}
