package jcg.ssowmya.demo.graphExample;

import org.junit.Before;
import org.junit.Test;

import java.util.List;

import static org.junit.Assert.assertNotNull;

public class ServerGraphTraversalTest {

    private ServerGraph serverGraph;
    private ServerVertex root;
    @Before
    public void initializeGraph() {
        serverGraph = new ServerGraph();
        ServerVertex wsVertex= new ServerVertex("WS1:Web Server",new ServerConfig("JCG Web Server 1","1.2.3.4","Web"));
        ServerVertex lb1Vertex = new ServerVertex("LB1:Load Balancer 1", new ServerConfig("JCG Load Balance Server 1","1.2.3.5","Load Balancer"));
        ServerVertex lb2Vertex = new ServerVertex("LB2:Load Balancer 2", new ServerConfig("JCG Load Balance Server 2","1.2.3.6","Load Balancer"));
        ServerVertex ps1Vertex = new ServerVertex("PS1:Proxy Server Instance 1", new ServerConfig("Proxy Server Instance 1","1.2.3.7","Proxy Server"));
        ServerVertex ps2Vertex = new ServerVertex("PS2:Proxy Server Instance 2", new ServerConfig("Proxy Server Instance 2","1.2.3.8","Proxy Server"));
        ServerVertex ps3Vertex = new ServerVertex("PS3:Proxy Server Instance 3", new ServerConfig("Proxy Server Instance 3","1.2.3.9","Proxy Server"));
        serverGraph.addServerVertex(wsVertex);
        serverGraph.addServerVertex(lb1Vertex);
        serverGraph.addServerVertex(lb2Vertex);
        serverGraph.addServerVertex(ps1Vertex);
        serverGraph.addServerVertex(ps2Vertex);
        serverGraph.addServerVertex(ps3Vertex);
        serverGraph.addEdge(new ServerEdge(wsVertex,lb1Vertex));
        serverGraph.addEdge(new ServerEdge(wsVertex,lb2Vertex));
        serverGraph.addEdge(new ServerEdge(lb1Vertex,ps1Vertex));
        serverGraph.addEdge(new ServerEdge(lb1Vertex,ps2Vertex));
        serverGraph.addEdge(new ServerEdge(lb2Vertex,ps3Vertex));
        root = wsVertex;
    }
    @Test
    public void testBreadthFirstTraversal() {
        List<ServerVertex> visitedList = serverGraph.breadthFirstTraversal(root);
        assertNotNull(visitedList);
        System.out.println("Breadth first traversal search path : ");
        visitedList.stream().forEach(sv->System.out.println(sv.getLabel()));
    }
    @Test
    public void testDepthFirstTraversal() {
        List<ServerVertex> visitedList = serverGraph.depthFirstTraversal(root);
        assertNotNull(visitedList);
        System.out.println("Depth first traversal search path : ");
        visitedList.stream().forEach(sv->System.out.println(sv.getLabel()));
    }
}
