package com.javacodegeeks.examples.corejava;

/**
 * @author Kevin Yang
 *
 */
public class MethodSignatureExample {
    /**
     * @param args
     */
    public static void main(String[] args) {
        // constructs a MethodSignatureExample instance
        MethodSignatureExample example = new MethodSignatureExample();
        // calls the first method
        System.out.println(example.hello("Kevin"));
        // calls the second method
        System.out.println(example.hello("Kevin", 1));

        // constructs a MethodSignatureExample instance
        MethodSignatureExample overrideExample = new MethodSignatureExample();
        // calls the hello method of MethodSignatureExample
        System.out.println(overrideExample.hello("Kevin"));
        // constructs an OverrideExample instance
        overrideExample = new OverrideExample();
        // calls the hello method of OverrideExample
        System.out.println(overrideExample.hello("Kevin"));   
    }

    /**
     * The first method's signature is "hello(String)".
     * 
     * @param name the first name
     * @return a hello string with name
     */
    public String hello(String name) {
        return "Hello, " + name + "!";
    }

    /**
     * The second method's signature is "hello(String, int)".
     * 
     * @param name the first name
     * @param mood 0 - sad face, 1 - happy face
     * @return a hello string with name and mood
     */
    public String hello(String name, int mood) {
        return "Hello, " + name + "! " + (mood == 0 ? ":(" : ":)");
    }

    private static class OverrideExample extends MethodSignatureExample {
        /**
         * Overrides the method "hello(String)" in superclass MethodSignatureExample by
         * adding " Nice to meet you!" to the return value.
         */
        @Override
        public String hello(String name) {
            return super.hello(name) + " Nice to meet you!";
        }
    }
}
