package jcg.zheng.demo.serialization;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializeManager {

	private static final String FILE_NAME_PREFIX = "ByteStream_";
	private static final String READ_OBJECT = "\nto an Object: ";

	public Object readByteStreamFromFileAndDeSerializeToObject(String filename)
			throws IOException, ClassNotFoundException {
		Object object = null;
		System.out.printf("\nDe-serialization bytestream from file: %s", filename);
		try (ObjectInputStream reader = new ObjectInputStream(new FileInputStream(filename))) {
			object = reader.readObject();
		}

		System.out.println(READ_OBJECT + object.toString());

		return object;
	}

	public void serializeObjectAndSaveToFile(Object input) throws FileNotFoundException, IOException {
		String fileName = FILE_NAME_PREFIX + input.getClass().getSimpleName();
		System.out.printf("\nSerialize object: %s \ninto a file: %s\n ", input.toString(), fileName);
		try (ObjectOutputStream writer = new ObjectOutputStream(new FileOutputStream(fileName))) {
			writer.writeObject(input);
		}
	}

}
