package com.javacodegeeks.examples.corejava;

/**
 * @author Kevin Yang
 *
 */
public class CustomWrapperClassExample {

    /**
     * @param args
     */
    public static void main(String[] args) {
        // create an Age instance from its constructor
        Age age10 = new Age(10);
        // print the age to standard output using its int value
        System.out.printf("My younger brother is %d years old\n", age10.intValue());
        
        // create an Age instance from a static factory method accepting int parameter
        Age age20 = Age.valueOf(20);
        // print the age to standard output using its int value
        System.out.printf("I am %d years old\n", age20.intValue());
        
        // create an Age instance from a static factory method accepting String parameter
        Age age30 = Age.valueOf("30");
        // print the age to standard output using its String value
        System.out.println("My older sister's age is " + age30.toString());
    }

    /**
     * Private static internal class for demo purpose.
     */
    private static class Age {

        // the variable holds the primitive age value
        private final int value;

        /**
         * Constructor.
         * 
         * @param age
         */
        public Age(int age) {
            this.value = age;
        }

        /**
         * Returns an {@code Age} object holding the value of the specified {@code int}.
         * 
         * @param age the age integer to be parsed.
         * @return an {@code Age} object holding the value represented by the integer argument.
         */
        public static Age valueOf(int age) {
            return new Age(age);
        }

        /**
         * Returns an {@code Age} object holding the value of the specified
         * {@code String}.
         * 
         * @param age the age string to be parsed.
         * @return an {@code Age} object holding the value represented by the String argument.
         */
        public static Age valueOf(String age) {
            return new Age(Integer.valueOf(age));
        }

        /**
         * @return the value
         */
        public int intValue() {
            return value;
        }

        @Override
        public String toString() {
            return Integer.toString(value);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + value;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj)
                return true;
            if (obj == null)
                return false;
            if (getClass() != obj.getClass())
                return false;
            Age other = (Age) obj;
            if (value != other.value)
                return false;
            return true;
        }
    }

}
