package com.javacodegeeks.data;

public class DeepCopyDemo {
	public static void main(String[] args) {
		MutablePOJO mary = new MutablePOJO();
		mary.setField("Mary");

		ImMutableHasMutableField maryObj = new ImMutableHasMutableField(mary);
		DeepCopyDemo sourceObj = new DeepCopyDemo("Mary", maryObj);

		System.out.println("Source object is " + sourceObj.toString());

		DeepCopyDemo copiedObj = sourceObj.deepCopy();

		System.out.println("Copied object is " + copiedObj.toString());

		mary.setField("Zheng");
		System.out.println("mary object changed " + mary.toString());

		System.out.println("Copied object is " + copiedObj.toString());

	}

	private final String name;

	private final ImMutableHasMutableField objectField1;

	public DeepCopyDemo(String name, ImMutableHasMutableField obj) {
		super();
		this.name = name;
		this.objectField1 = obj;
	}

	public DeepCopyDemo deepCopy() {
		return new DeepCopyDemo(this.name, new ImMutableHasMutableField(this.objectField1.getMutablePOJO()));
	}

	@Override
	public String toString() {
		return "DeepCopyDemo [name=" + name + ", objectField1=" + objectField1.toString() + "]";
	}
}
