package com.javacodegeeks.data;

public final class ImMutableHasMutableField {
	public static void main(String[] args) {

		MutablePOJO mutablePOJO = new MutablePOJO();
		mutablePOJO.setField("Mary");

		ImMutableHasMutableField testObj = new ImMutableHasMutableField(mutablePOJO);
		System.out.println("should print out Mary: " + testObj.toString());
		
		mutablePOJO.setField("Terry");
		System.out.println("mutablePOJO changed: " + mutablePOJO.toString());
		System.out.println("should print out Mary: " + testObj.toString());

	}

	private final MutablePOJO mutablePOJO;

	public ImMutableHasMutableField(MutablePOJO mutableField) {
		super();
		// this is how to ensure the mutablePOJO never change after the creation
		this.mutablePOJO = new MutablePOJO();
		this.mutablePOJO.setField(mutableField.getField());
	}

	public MutablePOJO getMutablePOJO() {
		// this is how to ensure the mutablePOJO never change after the creation
		// never return the mutablePOJO reference to keep
		MutablePOJO mutablePOJO = new MutablePOJO();
		mutablePOJO.setField(this.mutablePOJO.getField());

		return mutablePOJO;
	}

	@Override
	public String toString() {
		return "ImMutableHasMutableField [mutablePOJO=" + mutablePOJO.getField() + "]";
	}

}

class MutablePOJO {

	private String field;

	public String getField() {
		return field;
	}

	public void setField(String field1) {
		this.field = field1;
	}

	@Override
	public String toString() {
		return "MutablePOJO [field=" + field + "]";
	}

}
