package com.javacodegeeks.examples;

import java.util.Arrays;
import java.util.List;

/**
 * Class example for reading a book.
 * 
 * @author ezmairs
 */
public class BookReader {
	
	public BookReader(String name, int numOfPages, String path) {
		this.name = name;
		this.numOfPages = numOfPages;
		this.path = path;
	}

	private static final int READING_SPEED_MINUTES_PER_PAGE = 30;

	/**
	 * Name of the book.
	 */
	private String name;
	
	/**
	 * Number of pages.
	 */
	private int numOfPages;
	
	/**
	 * Path on the disk to the book.
	 */
	private String path;
	
	/**
	 * Method to read a book.
	 * 
	 * @param path Path, on the disk, to book. 
	 */
	public void readTheBook() {
		
		System.out.printf("Reading the book %s.\n", name);
		System.out.printf("Number of pages in the book %d.\n", numOfPages);
		
		int timeInMinutesForReading = READING_SPEED_MINUTES_PER_PAGE * numOfPages;
		
		List<String> lines = readAllLines(path);		
			
		for(String line: lines) {
			System.out.println(line);
		}
		
		System.out.printf("Time taken to read the entire book is %d min(s).\n", timeInMinutesForReading);
	}

	/**
	 * Read all lines from the book.
	 *  
	 * @param path Path, on the disk, to book. 
	 * @return
	 */
	private List<String> readAllLines(String path) {
		List<String> lines = Arrays.asList(new String[] {
			"Hello this is sample line 1",
			"Hello this is sample line 2",
			"Hello this is sample line 3"		
		});
		return lines;
	}
	
	public static void main(String[] args) {
		// Reader
		BookReader bookReader = new BookReader("Harry Potter and the Sorcerer’s Stone", 288, "harryPotter.pdf");
		
		// Read the book
		bookReader.readTheBook();
		
	}
}
