/**
 * 
 */
package com.javacodegeeks.examples;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

/**
 * Class to accept multiple requests.
 * 
 * @author Shivakumar Ramannavar
 *
 */
public class ShopkeeperScaled {

	ServerSocket shopSocket = null;
	
	boolean shutdown = false;
	
	/**
	 * Start a server running at the given port.
	 * 
	 * @param port Port at which server starts.
	 * @throws IOException
	 */
	public void start(int port) throws IOException {		

		shopSocket = new ServerSocket(port);
		System.out.println("Server multiple-requests version listening at port: " + port);
		System.out.println("Send STOP to shutdown the server.");

		while (!shutdown) { // The server would be shutdown when client sends 'STOP'
			runServer(port, shopSocket);
		}
		
	}

	private void runServer(int port, ServerSocket shopSocket) {
		
		if(shopSocket.isClosed())
			return;
			
		try {			
			Socket clientSocket = shopSocket.accept();

			Thread t = new Thread(() -> {
				processClient(clientSocket);
			});

			t.start();
		} catch(SocketException ex) {
			// Do Nothing!
		} catch (Exception ex) {
			System.err.println("Error starting the server." + ex.toString());
			ex.printStackTrace();
		} finally {
			
		}
	}

	private void processClient(Socket clientSocket) {
		ObjectOutputStream oos = null;

		ObjectInputStream ois = null;

		try {
			// Open an input stream to the socket.
			oos = new ObjectOutputStream(clientSocket.getOutputStream());

			// Open an input stream to the socket.
			ois = new ObjectInputStream(clientSocket.getInputStream());

			String request = (String) ois.readObject();
			
			System.out.println("Client says, " + request);
			
			if ("Give me 2 apples".equals(request)) {
				oos.writeObject("Take 2 apples");
			} if ("stop".equalsIgnoreCase(request)) {
				System.out.println("Shutdown received!");
				oos.writeObject("Thank you!");
				shutdown = true;
			} else {
				oos.writeObject("Sorry I dont know what you are saying");
			}
		} catch (IOException | ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			try {
				if (oos != null)
					oos.close();

				if (ois != null)
					ois.close();

				clientSocket.close();
				
				if(shutdown)
					shopSocket.close();
				
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

	public static void main(String[] args) {
		ShopkeeperScaled shopKeeper = new ShopkeeperScaled();
		try {
			shopKeeper.start(9999);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

}
