import java.lang.InterruptedException;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;

public class SleepMessage{
    public static void main(String args[]) throws InterruptedException {
        // List of names to print
        String names[] = {"James","Peter","Harry","Jenny"};
        LocalTime time1, time2;
        
        // example for Thread.sleep(long millis)
        for(String strName: names){
            time1 = LocalTime.now();
            Thread.sleep(2000);
            time2 = LocalTime.now();
            System.out.println("Contacted " + strName + " in " + time1.until(time2, ChronoUnit.MILLIS) + " milli seconds.");
        }
        
        // example for Thread.sleep(long millis, int nanos)
        System.out.println("Let us now repeat with nano second delays");
        for(String strName: names){
            time1 = LocalTime.now();
            Thread.sleep(1000,800000);
            time2 = LocalTime.now();
            System.out.println("Contacted " + strName + " in " + time1.until(time2, ChronoUnit.NANOS) + " nano seconds.");
        }
        
    }
}