package com.springboot.pagination.boot;

import com.springboot.pagination.model.Movie;
import com.springboot.pagination.service.MovieService;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

@Component
public class SaveMovies {

    private static final Logger LOGGER = LoggerFactory.getLogger(SaveMovies.class);

    @Autowired
    MovieService movieService;

    // The annotation will cause the method to get executed after the spring bean is initialized.
    @PostConstruct
    public void onApplicationStartup() {
        saveRandomMoviesInDatabase();
    }

    private void saveRandomMoviesInDatabase() {
        LOGGER.info("Saving the random movie details into the database.");
        for (int i = 0; i < 21; i++) {
            final Movie movie = new Movie();
            movie.setTitle(RandomStringUtils.randomAlphabetic(5));
            movie.setDescription(RandomStringUtils.randomAlphabetic(200));
            movie.setReleased(RandomUtils.nextBoolean());
            movieService.save(movie);
        }
    }
}
