package com.springboot.pagination.dao;

import com.springboot.pagination.model.Movie;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

public interface MovieRepository extends JpaRepository<Movie, Long> {

    // Fetch all movies by their release status and order them by movie them in an ascending order.
    Page<Movie> findByReleasedOrderByTitleAsc(boolean released, Pageable pageable);
}
