package com.springboot.pagination.dto;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.springboot.pagination.model.Movie;

// @JsonInclude annotation ensures that only non null values are sent in the response.
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public final class ResponseDto {

    private final List<Movie> movies;
    private final int totalItems;
    private final int totalPages;
    private final int currentPage;
    private final Boolean isFirstPage;
    private final Boolean isLastPage;

    private ResponseDto(final List<Movie> movies, final int totalItems, final int totalPages, final int currentPage, 
    		final Boolean isFirstPage, final Boolean isLastPage) {
        this.movies = movies;
        this.totalItems = totalItems;
        this.totalPages = totalPages;
        this.currentPage = currentPage;
        this.isFirstPage = isFirstPage;
        this.isLastPage = isLastPage;
    }

    public static ResponseDto create(final List<Movie> movies, final int totalItems, final int totalPages, 
    		final int currentPage, final Boolean isFirstPage, final Boolean isLastPage) {
        return new ResponseDto(movies, totalItems, totalPages, currentPage, isFirstPage, isLastPage);
    }

    public List<Movie> getMovies() {
        return movies;
    }

    public int getTotalItems() {
        return totalItems;
    }

    public int getTotalPages() {
        return totalPages;
    }

    public int getCurrentPage() {
        return currentPage;
    }

	public Boolean getIsFirstPage() {
		return isFirstPage;
	}

	public Boolean getIsLastPage() {
		return isLastPage;
	}
}
