package com.springboot.pagination.service;

import com.springboot.pagination.dao.MovieRepository;
import com.springboot.pagination.model.Movie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class MovieService {

    private static final Logger LOGGER = LoggerFactory.getLogger(MovieService.class);

    @Autowired
    MovieRepository movieRepository;

    // Save movies in the database.
    public void save(final Movie movie) {
        movieRepository.save(movie);
    }

    // Fetch all movies from the database.
    public Page<Movie> getAllMovies(final Pageable pageable) {
        LOGGER.info("Fetching all movies from the database.");
        return movieRepository.findAll(pageable);
    }

    // Fetch all movies from the database for the given released type.
    public Page<Movie> findByReleased(final boolean isMovieReleased, final Pageable pageable) {
        LOGGER.info("Fetching all movies from the database where isMovieReleased flag= {}.", isMovieReleased);
        return movieRepository.findByReleasedOrderByTitleAsc(isMovieReleased, pageable);
    }
}
