package com.jcg.controller;

import com.jcg.dto.StudentResponse;
import com.jcg.service.StudentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;


@RestController
@RequestMapping("/api")
public class SimpleController {
    @Autowired
    StudentService studentService;

    @RequestMapping(value = "/students", method = RequestMethod.GET)
    public @ResponseBody
    StudentResponse getStudents() throws Exception {
        StudentResponse response = new StudentResponse();
        response.setStudents(studentService.fetchAllStrudents());
        return response;
    }
}
