package com.jcg.dao;

import com.jcg.entity.Student;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import javax.persistence.criteria.CriteriaQuery;
import java.util.List;

@Repository
public class StudentDao {

    @Autowired
    private SessionFactory sessionFactory;

    public List<Student> getAllStudents() throws Exception{
        Session session = sessionFactory.getCurrentSession();
        CriteriaQuery<Student> query = session.getCriteriaBuilder().createQuery(Student.class);
        query.select(query.from(Student.class));
        return session.createQuery(query).getResultList();
    }

    public void saveStudent(Student student) {
        Session session = sessionFactory.getCurrentSession();
        session.save(student);
    }
}
